﻿/*	VERSION:  1.1

USAGE:
	#include "functions/evalpath.as"
	path = "myObj.subObj.myVar";
	result = evalpath( path, "RAM" );

DESCRIPTION:
	Get the value of the specified variable.
	(Returns the value of a variable specified by a string path)
*/
#include "getImpliedValue.as"
evalPath = function( inputPath, defaultContainer )
{
	// resolve defaultContainer
	if(!defaultContainer)
		var defaultContainer = this;
	// get assumed container
	var endAt = inputPath.indexOf(".");
	// if there is no sub-path, assume the entire path is the container
	if(endAt==-1)
		endAt = inputPath.length;
	var container_str = inputPath.substr(0, endAt);
	// verify that it's a container
	var container = null;
	// // treat "this" as a container
	if(container_str == "this")
		var container = "_this";
	// // treat "_level0" as a container
	if(container_str == "_level0")
		var container = "_level0";
	// // check globals for this container
	if(_global[container_str])
		var container = container_str;
	// if:  it's not a container
	if( !container ){
		var container = defaultContainer;
		endAt = -1;
	}
	// eval the path
	var theRest = inputPath.substr(endAt+1);
	var fullPath = (theRest) ? container+"."+theRest : container;
	// handle functions
	var paramStart = fullPath.indexOf("(");
	if(paramStart != -1)
	{// if:  result is a function
		var paramEnd = fullPath.indexOf(")", paramStart+1);
		var param = fullPath.substring(paramStart+1, paramEnd);
		//var param = getImpliedValue(param);
		var functionPath = fullPath.substr(0,paramStart);
		var thisFunction = eval(functionPath);
		
		var param_array = String(param).split(",");
		for(var i=0; i<param_array.length; i++)
			param_array[i] = getImpliedValue(param_array[i]);
		// // 	params that are strings cannot contain:		[ ] ( ) ,
		// // 	"" are not used in parameters, so be careful with spaces in all params, regardless of type
		// do function call
		var output = thisFunction.apply( this, param_array );
	}// if:  result is a function
	else
	{// if:  result is NOT a function
		// handle non-functions
		var output = eval(fullPath);
	}// if:  result is NOT a function
	// return the result
	return output;
}// evalPath()